package pbutil

import (
	"fmt"

	"github.com/golang/protobuf/ptypes"

	pb "a.yandex-team.ru/infra/maxwell/go/proto"
)

func setCondition(cond *pb.Condition, status, message string) {
	if cond.Status != status {
		cond.TransitionTime = ptypes.TimestampNow()
	}
	cond.Status = status
	cond.Message = message
}

func SetFalse(cond *pb.Condition, message string) {
	setCondition(cond, "False", message)
}

func SetTrue(cond *pb.Condition, message string) {
	setCondition(cond, "True", message)
}

func False(cond *pb.Condition) bool {
	return cond.Status == "False"
}

func True(cond *pb.Condition) bool {
	return cond.Status == "True"
}

func UnknownCond(cond *pb.Condition, message string) {
	setCondition(cond, "Unknown", message)
}

func FmtCondition(c *pb.Condition) string {
	return fmt.Sprintf("%s (%s)", c.Status, c.Message)
}
