package filter

import (
	"a.yandex-team.ru/infra/maxwell/go/internal/validators"
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
	"strings"
)

type Automation struct {
	s *pb.Filter_Automation
}

// Exclude host which does not satisfy automating selector
func (r *Automation) Filter(hosts []*pb.Host, projects map[string]*pb.Project, l log.Logger) []*pb.Host {
	filtered := make([]*pb.Host, 0)
	for _, h := range hosts {
		project, ok := projects[h.Project]
		if !ok {
			l.Errorf("%s project not exists in state, skipping", h.Project)
			continue
		}
		if errs := validators.Automation(r.s, project); len(errs) == 0 {
			filtered = append(filtered, h)
		} else {
			l.Infof("Skipping '%s': %s", h.Hostname, strings.Join(errs, ", "))
		}
	}
	return filtered
}
