package filter

import (
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
)

type Filter interface {
	Filter(hosts []*pb.Host, projects map[string]*pb.Project, l log.Logger) []*pb.Host
}

func NewHealth(f *pb.Filter_Health) Filter             { return &Health{s: f} }
func NewRestrictions(f *pb.Filter_Restrictions) Filter { return &Restrictions{s: f} }
func NewAutomation(f *pb.Filter_Automation) Filter     { return &Automation{s: f} }
