package filter

import (
	"strings"

	"a.yandex-team.ru/infra/maxwell/go/internal/validators"
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
)

type Health struct {
	s *pb.Filter_Health
}

// Exclude host which does not satisfy health selector
func (h *Health) Filter(hosts []*pb.Host, _ map[string]*pb.Project, l log.Logger) []*pb.Host {
	filtered := make([]*pb.Host, 0)
	for _, host := range hosts {
		if errs := validators.Health(host, h.s); len(errs) == 0 {
			filtered = append(filtered, host)
		} else {
			l.Infof("Skipping '%s': %s", host.Hostname, strings.Join(errs, ", "))
		}
	}
	return filtered
}
