package filter

import (
	"testing"

	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/test/assertpb"
)

func TestHealth_Filter(t *testing.T) {
	tests := []struct {
		name   string
		health *pb.Filter_Health
		before []*pb.Host
		after  []*pb.Host
	}{{
		name: "skip health.in",
		health: &pb.Filter_Health{
			Ok:     make([]string, 0),
			Failed: []string{"need_reboot_kernel"},
		},
		before: []*pb.Host{{
			Health:   map[string]string{"need_reboot_kernel": "passed"},
			Project:  "rtc",
			Hostname: "test.search.yandex.net",
			Status:   "ready",
		}},
		after: make([]*pb.Host, 0),
	}, {
		name: "skip health.nin",
		health: &pb.Filter_Health{
			Ok:     make([]string, 0),
			Failed: []string{"need_reboot_kernel"},
		},
		before: []*pb.Host{{
			Health:   map[string]string{"need_reboot_kernel": "passed"},
			Project:  "rtc",
			Hostname: "test.search.yandex.net",
			Status:   "ready",
		}},
		after: make([]*pb.Host, 0),
	}, {
		name: "ok host",
		health: &pb.Filter_Health{
			Ok:     make([]string, 0),
			Failed: []string{"need_reboot_kernel"},
		},
		before: []*pb.Host{{
			Health:   map[string]string{"need_reboot_kernel": "failed"},
			Project:  "rtc",
			Hostname: "test.search.yandex.net",
			Status:   "ready",
		}},
		after: []*pb.Host{{
			Health:   map[string]string{"need_reboot_kernel": "failed"},
			Project:  "rtc",
			Hostname: "test.search.yandex.net",
			Status:   "ready",
		}},
	}}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			h := &Health{
				s: tt.health,
			}
			p := make(map[string]*pb.Project)
			l, _ := zap.New(zap.CLIConfig(log.DebugLevel))
			got := h.Filter(tt.before, p, l)
			if len(got) != len(tt.after) {
				t.Errorf("len(before) != len(after) | %d != %d", len(tt.before), len(tt.after))
				return
			}
			for i := 0; i < len(got); i++ {
				gotHost := got[i]
				expectedHost := tt.after[i]
				assertpb.Equal(t, expectedHost, gotHost)
			}
		})
	}
}
