package filter

import (
	"strings"

	"a.yandex-team.ru/infra/maxwell/go/internal/validators"
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
)

type Restrictions struct {
	s *pb.Filter_Restrictions
}

// Exclude host which does not satisfy restrictions selector
func (r *Restrictions) Filter(hosts []*pb.Host, projects map[string]*pb.Project, l log.Logger) []*pb.Host {
	filtered := make([]*pb.Host, 0)
	for _, h := range hosts {
		project, ok := projects[h.Project]
		if !ok {
			l.Errorf("Skipping '%s': %s project not exists in state", h.Hostname, h.Project)
			continue
		}
		if errs := validators.Restrictions(h, r.s, project); len(errs) > 0 {
			l.Infof("Skipping '%s': %s", h.Hostname, strings.Join(errs, ", "))
			continue
		}
		filtered = append(filtered, h)
	}
	return filtered
}
