package group

import (
	"fmt"

	pb "a.yandex-team.ru/infra/maxwell/go/proto"
)

func Group(hosts []*pb.Host, ordered []string, groups []string) (grouped map[string][]string, order []string) {
	grouped = make(map[string][]string)
	order = make([]string, 0)
	hostsMap := make(map[string]*pb.Host)
	for _, host := range hosts {
		hostsMap[host.Hostname] = host
	}
	for _, name := range ordered {
		h := hostsMap[name]
		g := HostGroup(h, groups)
		if _, ok := grouped[g]; !ok {
			grouped[g] = make([]string, 0)
			order = append(order, g)
		}
		grouped[g] = append(grouped[g], name)
	}
	return grouped, order
}

const (
	LocationGroup = "location"
	RackGroup     = "rack"
)

func HostGroup(h *pb.Host, groups []string) string {
	result := ""
	for _, group := range groups {
		switch group {
		case LocationGroup:
			if len(result) > 0 {
				result += "|"
			}
			location := fmt.Sprintf("%s|%s", h.Location.Country, h.Location.City)
			result += location
		case RackGroup:
			if len(result) > 0 {
				result += "|"
			}
			result += fmt.Sprintf("%s|%s", h.Location.Queue, h.Location.Rack)
		}
	}
	return result
}
