package order

import (
	"fmt"

	pb "a.yandex-team.ru/infra/maxwell/go/proto"
)

func Dc(a, b *pb.Host_Location) int {
	return str(dcFromLocation(a), dcFromLocation(b))
}

func dcFromLocation(l *pb.Host_Location) string {
	return fmt.Sprintf("%s|%s", l.Country, l.City)
}

func rackFromLocation(l *pb.Host_Location) string {
	return fmt.Sprintf("%s|%s", l.Queue, l.Rack)
}

func Rack(a, b *pb.Host_Location) int {
	return str(rackFromLocation(a), rackFromLocation(b))
}

func Hostname(a, b string) int {
	return str(a, b)
}

func str(a, b string) int {
	if a > b {
		return 1
	}
	if a < b {
		return -1
	}
	return 0
}
