package source

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/retry"
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
	"a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
)

func NewHostList(selector *pb.Source_HostList) Source {
	return &HostList{
		selector: selector,
	}
}

type HostList struct {
	selector *pb.Source_HostList
}

func (p *HostList) Hosts(w walle.IClient, l log.Logger) ([]*pb.Host, map[string]*pb.Project, error) {
	hosts := make([]*pb.Host, 0)
	projects := make(map[string]*pb.Project)
	batch := make([]string, 0, 1000)
	l.Infof("%d hosts in hostlist", len(p.selector.HostNames))
	for _, h := range p.selector.HostNames {
		batch = append(batch, h)
		if len(batch) >= 1000 {
			resp, err := w.GetHostsByNames(batch)
			if err != nil {
				return nil, nil, err
			}
			// Append hosts in result in source order.
			for _, hostname := range batch {
				if h, ok := resp[hostname]; ok {
					l.Infof("Fetched %s from hostlist source", hostname)
					hosts = append(hosts, h)
				} else {
					l.Warnf("%s not found in wall-e", hostname)
				}
			}
			batch = make([]string, 0, 1000)
		}
	}
	if len(batch) != 0 {
		resp := make(map[string]*pb.Host)
		err := retry.Retry(func() error {
			var err error
			resp, err = w.GetHostsByNames(batch)
			return err
		})
		if err != nil {
			return nil, nil, err
		}
		for _, hostname := range batch {
			if h, ok := resp[hostname]; ok {
				l.Infof("Fetched %s from hostlist source", hostname)
				hosts = append(hosts, h)
			} else {
				l.Warnf("%s not found in wall-e", hostname)
			}
		}
	}
	// Fetch all needed projects for hosts
	for _, h := range hosts {
		// Skip hosts missing in walle, but present in the list.
		if h.Project == "" {
			continue
		}
		project, ok := projects[h.Project]
		if !ok {
			err := retry.Retry(func() error {
				var err error
				project, err = w.GetProject(h.Project)
				return err
			})
			if err != nil {
				l.Errorf("Failed to get project: %s", err.Error())
				return nil, nil, err
			}
			projects[h.Project] = project
		}
	}
	return hosts, projects, nil
}
