package source

import (
	"fmt"

	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
	"a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
)

type Source interface {
	Hosts(w walle.IClient, l log.Logger) ([]*pb.Host, map[string]*pb.Project, error)
}

func NewSource(s *pb.Source) Source {
	switch t := s.Source.(type) {
	case *pb.Source_HostList_:
		return NewHostList(t.HostList)
	case *pb.Source_Walle_:
		return NewWalle(t.Walle)
	}
	panic(fmt.Sprintf("unknown source: %v", s))
}
