package source

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/retry"
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
	"a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
	"time"
)

func NewWalle(source *pb.Source_Walle) Source { return &Walle{source: source} }

type Walle struct {
	source *pb.Source_Walle
}

func (p *Walle) Hosts(w walle.IClient, l log.Logger) ([]*pb.Host, map[string]*pb.Project, error) {
	hosts := make([]*pb.Host, 0)
	projects := make(map[string]*pb.Project)
	cursor := 0
	// Requests limit and fetch limit
	// reqLimit * fetchLimit > RTC hosts conn
	reqLimit := 150
	fetchLimit := 1000
	l.Infof("Fetching hosts from wall-e source...")
	for i := 0; i < reqLimit; i++ {
		resp := &walle.GetHostsResponse{}
		err := retry.Retry(func() error {
			var err error
			resp, err = w.GetHosts(&walle.GetHostsRequest{
				Cursor:     cursor,
				FetchLimit: fetchLimit,
				Project:    p.source.Project,
				Tags:       p.source.Tags,
				Location:   p.source.Location,
			})
			return err
		})
		if err != nil {
			return nil, nil, err
		}
		cursor = resp.NextCursor
		// we fetched all hosts
		for _, h := range resp.Hosts {
			l.Infof("Fetched %s from wall-e source", h.Hostname)
			hosts = append(hosts, h)
			project, ok := projects[h.Project]
			if !ok {
				err := retry.Retry(func() error {
					var err error
					project, err = w.GetProject(h.Project)
					return err
				})
				if err != nil {
					l.Errorf("Failed to get project: %s", err.Error())
					return nil, nil, err
				}
				projects[h.Project] = project
			}
		}
		if len(resp.Hosts) == 0 || cursor == 0 {
			break
		}
		time.Sleep(50 * time.Millisecond)
	}
	l.Infof("Fetched %d hosts from wall-e source", len(hosts))
	return hosts, projects, nil
}
