package storages

import (
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
)

func NewYpNodesInMemory(nodes ...*pb.YpNode) *YpNodesInMemory {
	nodesMap := make(map[string]*pb.YpNode)
	for _, node := range nodes {
		nodesMap[node.MetaId] = node
	}
	return &YpNodesInMemory{nodes: nodesMap}
}

type YpNodesInMemory struct {
	nodes map[string]*pb.YpNode
}

func (s *YpNodesInMemory) PutNodes(nodes map[string]*pb.YpNode) error {
	s.nodes = nodes
	return nil
}

func (s *YpNodesInMemory) Pop(MetaID string) error {
	delete(s.nodes, MetaID)
	return nil
}

func (s *YpNodesInMemory) Nodes() (map[string]*pb.YpNode, error) {
	return s.nodes, nil
}

func (s *YpNodesInMemory) Node(MetaID string) (*pb.YpNode, error) {
	return s.nodes[MetaID], nil
}

func NewNannyServicesInMemory(services ...*pb.NannyService) *NannyServicesInMemory {
	servicesMap := make(map[string]*pb.NannyService)
	for _, service := range services {
		servicesMap[service.MetaId] = service
	}
	return &NannyServicesInMemory{services: servicesMap}
}

type NannyServicesInMemory struct {
	services map[string]*pb.NannyService
}

func (s *NannyServicesInMemory) PutServices(services map[string]*pb.NannyService) error {
	s.services = services
	return nil
}

func (s *NannyServicesInMemory) Pop(service string) error {
	delete(s.services, service)
	return nil
}

func (s *NannyServicesInMemory) Services() (map[string]*pb.NannyService, error) {
	return s.services, nil
}

func (s *NannyServicesInMemory) Service(MetaID string) (*pb.NannyService, error) {
	return s.services[MetaID], nil
}
