package etcdutil

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/golang/protobuf/proto"
	"go.etcd.io/etcd/clientv3"
)

func PutInterface(c *clientv3.Client, key string, data interface{}) error {
	ctx := context.Background()
	marshaled, err := json.Marshal(&data)
	if err != nil {
		return err
	}
	_, err = c.Put(ctx, key, string(marshaled))
	return err
}

func GetInterface(c *clientv3.Client, key string) ([]byte, error) {
	resp, err := c.Get(context.Background(), key)
	if err != nil {
		return nil, err
	}
	if len(resp.Kvs) == 0 {
		return nil, nil
	}
	if len(resp.Kvs) != 1 {
		return nil, fmt.Errorf("invalid etcd response format")
	}
	return resp.Kvs[0].Value, nil
}

func PutProto(c *clientv3.Client, key string, data proto.Message) error {
	ctx := context.Background()
	marshaled, err := proto.Marshal(data)
	if err != nil {
		return err
	}
	_, err = c.Put(ctx, key, string(marshaled))
	return err
}
