package storages

import (
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
)

func NewHostsInMemory(hosts ...*pb.Host) *HostsInMemory {
	hostsMap := make(map[string]*pb.Host)
	for _, host := range hosts {
		hostsMap[host.Hostname] = host
	}
	return &HostsInMemory{hosts: hostsMap}
}

type HostsInMemory struct {
	hosts map[string]*pb.Host
}

func (s *HostsInMemory) PutHosts(hosts map[string]*pb.Host) error {
	s.hosts = hosts
	return nil
}

func (s *HostsInMemory) Pop(hostname string) error {
	delete(s.hosts, hostname)
	return nil
}

func (s *HostsInMemory) Hosts() (map[string]*pb.Host, error) {
	return s.hosts, nil
}

func (s *HostsInMemory) Host(hostname string) (*pb.Host, error) {
	return s.hosts[hostname], nil
}
