package storages

import (
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
)

func NewJobsInMemory() *JobsInMemory {
	return &JobsInMemory{jobs: make(map[string]*pb.Job)}
}

type JobsInMemory struct {
	jobs map[string]*pb.Job
}

func (s *JobsInMemory) Put(job *pb.Job) error {
	s.jobs[job.Spec.Name] = job
	return nil
}

func (s *JobsInMemory) Get(name string) (*pb.Job, error) {
	return s.jobs[name], nil
}

func (s *JobsInMemory) List() ([]*pb.Job, error) {
	list := make([]*pb.Job, 0, len(s.jobs))
	for _, job := range s.jobs {
		list = append(list, job)
	}
	return list, nil
}

func (s *JobsInMemory) Names() ([]string, error) {
	list := make([]string, 0, len(s.jobs))
	for _, job := range s.jobs {
		list = append(list, job.Spec.Name)
	}
	return list, nil
}

func (s *JobsInMemory) Delete(name string) error {
	delete(s.jobs, name)
	return nil
}
