package storages

import (
	"context"
	"fmt"

	"go.etcd.io/etcd/clientv3"
)

func NewManagerETCD(c *clientv3.Client) *ManagerETCD {
	return &ManagerETCD{c: c}
}

type ManagerETCD struct {
	c *clientv3.Client
}

const managerPrefix = "manager"

func (e *ManagerETCD) Master() (string, error) {
	key := fmt.Sprintf("/%s/master", managerPrefix)
	resp, err := e.c.Get(context.Background(), key)
	if err != nil {
		return "", err
	}
	if len(resp.Kvs) == 0 {
		return "", nil
	}
	if len(resp.Kvs) > 1 {
		return "", fmt.Errorf("invalid value in %s, should be single string, but was %v", key, resp.Kvs)
	}
	return string(resp.Kvs[0].Value), nil
}
