package storages

import (
	"context"
	"encoding/json"
	"fmt"

	"go.etcd.io/etcd/clientv3"

	"a.yandex-team.ru/infra/maxwell/go/internal/storages/etcdutil"
)

const poolPrefix = "pool"

func NewPoolETCD(c *clientv3.Client, name string) *PoolETCD {
	return &PoolETCD{c: c, name: name}
}

type PoolETCD struct {
	c    *clientv3.Client
	name string
}

func (s *PoolETCD) PutGroups(groups map[string][]string) error {
	key := fmt.Sprintf("/%s/%s/groups", s.name, poolPrefix)
	return etcdutil.PutInterface(s.c, key, groups)
}

func (s *PoolETCD) Groups() (map[string][]string, error) {
	key := fmt.Sprintf("/%s/%s/groups", s.name, poolPrefix)
	groups := make(map[string][]string)
	data, err := etcdutil.GetInterface(s.c, key)
	if err != nil {
		return nil, err
	}
	if err := json.Unmarshal(data, &groups); err != nil {
		return nil, err
	}
	return groups, nil
}

func (s *PoolETCD) PutGroupsOrder(order []string) error {
	key := fmt.Sprintf("/%s/%s/order", s.name, poolPrefix)
	return etcdutil.PutInterface(s.c, key, order)
}

func (s *PoolETCD) GroupsOrder() ([]string, error) {
	order := make([]string, 0)
	key := fmt.Sprintf("/%s/%s/order", s.name, poolPrefix)
	data, err := etcdutil.GetInterface(s.c, key)
	if err != nil {
		return nil, err
	}
	if err := json.Unmarshal(data, &order); err != nil {
		return nil, err
	}
	return order, nil
}

func (s *PoolETCD) Delete() error {
	key := fmt.Sprintf("%s/%s", s.name, poolPrefix)
	_, err := s.c.Delete(context.Background(), key)
	return err
}
