package storages

func NewPoolInMemory() *PoolInMemory {
	return &PoolInMemory{
		groups:      make(map[string][]string),
		groupsOrder: make([]string, 0),
	}
}

type PoolInMemory struct {
	groups      map[string][]string
	groupsOrder []string
}

func (s *PoolInMemory) PutGroups(groups map[string][]string) error {
	s.groups = groups
	return nil
}

func (s *PoolInMemory) Groups() (map[string][]string, error) {
	return s.groups, nil
}

func (s *PoolInMemory) PutGroupsOrder(order []string) error {
	s.groupsOrder = order
	return nil
}

func (s *PoolInMemory) GroupsOrder() ([]string, error) {
	return s.groupsOrder, nil
}
