package storages

func NewProcessedInMemory() *ProcessedInMemory {
	return &ProcessedInMemory{processed: make([]string, 0)}
}

type ProcessedInMemory struct {
	processed []string
	enforced  []string
}

func (e *ProcessedInMemory) AppendProcessed(hostnames []string) error {
	e.processed = append(e.processed, hostnames...)
	return nil
}

func (e *ProcessedInMemory) Processed() ([]string, error) {
	return e.processed, nil
}

func (e *ProcessedInMemory) AppendEnforced(hostnames []string) error {
	e.enforced = append(e.enforced, hostnames...)
	return nil
}

func (e *ProcessedInMemory) Enforced() ([]string, error) {
	return e.enforced, nil
}
