package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func DrivesUpdateWithRedeploy(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "drives_update_with_redeploy",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.ProfileHost(&walle.ProfileHostRequest{
				HostID: hostname,
				Body: walle.ProfileHostBody{
					ProfileTags:     []string{"drives_update"},
					Redeploy:        true,
					WithAutoHealing: true,
					Reason:          reason,
					IgnoreCms:       ignoreCMS,
				},
			})
			return err
		},
	}
}
