package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func WalleHandleFailure(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "walle_handle_failure",
		Action: func(w walle.IClient, hostname string) error {
			return w.HandleFailure(hostname, &walle.HandleFailureRequest{
				Check:                true,
				DisableAdminRequests: false,
				IgnoreCms:            ignoreCMS,
				Reason:               reason,
				WithAutoHealing:      true,
			})
		},
	}
}
