package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func FullProfile(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "full_profile",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.ProfileHost(&walle.ProfileHostRequest{
				HostID: hostname,
				Body: walle.ProfileHostBody{
					ProfileTags:     []string{"advanced_load", "full_profiling", "rtc"},
					Redeploy:        false,
					WithAutoHealing: true,
					Reason:          reason,
					IgnoreCms:       ignoreCMS,
				},
			})
			return err
		},
	}
}

func FullProfileWithRedeploy(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "full_profile_with_redeploy",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.ProfileHost(&walle.ProfileHostRequest{
				HostID: hostname,
				Body: walle.ProfileHostBody{
					ProfileTags:     []string{"advanced_load", "full_profiling", "rtc"},
					Redeploy:        true,
					WithAutoHealing: true,
					Reason:          reason,
					IgnoreCms:       ignoreCMS,
				},
			})
			return err
		},
	}
}
