package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func Reboot(reason string, ignoreCMS bool, ssh string, kexec bool) *WalleTask {
	if kexec {
		return rebootKexec(reason, ignoreCMS)
	}
	return reboot(reason, ignoreCMS, ssh)
}

func reboot(reason string, ignoreCMS bool, ssh string) *WalleTask {
	return &WalleTask{
		Description: "reboot",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.RebootHost(&walle.RebootHostRequest{
				HostID: hostname,
				Body: walle.RebootHostBody{
					WithAutoHealing: true,
					IgnoreCms:       ignoreCMS,
					Reason:          reason,
					SSH:             ssh,
				},
			})
			return err
		},
	}
}

func rebootKexec(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "reboot",
		Action: func(w walle.IClient, hostname string) error {
			return w.RebootKexec(hostname, &walle.RebootKexecHostBody{
				WithAutoHealing: true,
				IgnoreCms:       ignoreCMS,
				Reason:          reason,
			})
		},
	}
}
