package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func Redeploy(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "redeploy",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.RedeployHost(&walle.RedeployHostRequest{
				HostID: hostname,
				Body: walle.RedeployHostBody{
					Reason:          reason,
					WithAutoHealing: true,
					IgnoreCms:       ignoreCMS,
				},
			})
			return err
		},
	}
}
