package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func FirmwareUpdate(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "firmware_update",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.ProfileHost(&walle.ProfileHostRequest{
				HostID: hostname,
				Body: walle.ProfileHostBody{
					ProfileTags:     []string{"firmware_update", "rtc"},
					Redeploy:        false,
					WithAutoHealing: true,
					Reason:          reason,
					IgnoreCms:       ignoreCMS,
				},
			})
			return err
		},
	}
}
