package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
)

func FirmwareUpdateWithRedeploy(reason string, ignoreCMS bool) *WalleTask {
	return &WalleTask{
		Description: "firmware_update_with_redeploy",
		Action: func(w walle.IClient, hostname string) error {
			_, err := w.ProfileHost(&walle.ProfileHostRequest{
				HostID: hostname,
				Body: walle.ProfileHostBody{
					ProfileTags:     []string{"firmware_update"},
					Redeploy:        true,
					WithAutoHealing: true,
					Reason:          reason,
					IgnoreCms:       ignoreCMS,
				},
			})
			return err
		},
	}
}
