package tasks

import (
	"a.yandex-team.ru/infra/maxwell/go/pkg/walle"
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"a.yandex-team.ru/library/go/core/log"
)

func CheckStarted(l log.Logger, w walle.IClient, hostname string) (bool, error) {
	l.Infof("Check task been started on '%s'", hostname)
	host, err := getWalleStatus(w, hostname)
	if err != nil {
		return false, err
	}
	// host.Status != ready means that action has been started
	return host.Status != "ready", nil
}

func getWalleStatus(w walle.IClient, hostID string) (*pb.Host, error) {
	newHostInfo, err := w.GetHost(hostID)
	if err != nil {
		return nil, err
	}
	return newHostInfo, nil
}
