package retry

import (
	"fmt"
	"strings"
	"time"
)

const (
	delay = 20 * time.Second
	count = 3
)

func RetryN(f func() error, n int) error {
	errs := make([]string, 0)
	for i := 0; i < n; i++ {
		err := f()
		if err == nil {
			return nil
		}
		errs = append(errs, err.Error())
		time.Sleep(delay)
	}
	return fmt.Errorf("failed to perform, after %d attemts: %s", n, strings.Join(errs, ";"))
}

func Retry(f func() error) error {
	return RetryN(f, count)
}
