package walle

import (
	pb "a.yandex-team.ru/infra/maxwell/go/proto"
	"github.com/stretchr/testify/mock"
)

type Fake struct {
	mock.Mock
}

func (f *Fake) GetHost(hostname string) (*pb.Host, error) {
	args := f.Called(hostname)
	return args.Get(0).(*pb.Host), args.Error(1)
}

func (f *Fake) GetProject(name string) (*pb.Project, error) {
	args := f.Called(name)
	return args.Get(0).(*pb.Project), args.Error(1)
}

func (f *Fake) GetHosts(req *GetHostsRequest) (*GetHostsResponse, error) {
	args := f.Called(req)
	return args.Get(0).(*GetHostsResponse), args.Error(1)
}

func (f *Fake) GetHostsByNames(strings []string) (map[string]*pb.Host, error) {
	args := f.Called(strings)
	return args.Get(0).(map[string]*pb.Host), args.Error(1)
}

func (f *Fake) ProfileHost(req *ProfileHostRequest) ([]byte, error) {
	args := f.Called(req)
	return args.Get(0).([]byte), args.Error(1)
}

func (f *Fake) RedeployHost(req *RedeployHostRequest) ([]byte, error) {
	args := f.Called(req)
	return args.Get(0).([]byte), args.Error(1)
}

func (f *Fake) RebootHost(req *RebootHostRequest) ([]byte, error) {
	args := f.Called(req)
	return args.Get(0).([]byte), args.Error(1)
}

func (f *Fake) RebootKexec(hostname string, req *RebootKexecHostBody) error {
	args := f.Called(hostname, req)
	return args.Error(0)
}

func (f *Fake) GetHealthCheck(fqdn string, checkName string) (*HealthCheck, error) {
	args := f.Called(fqdn, checkName)
	return args.Get(0).(*HealthCheck), args.Error(1)
}

func (f *Fake) FirmwareProblems(fqdn string) ([]string, error) {
	args := f.Called(fqdn)
	return args.Get(0).([]string), args.Error(1)
}

func (f *Fake) GetHealthChecks(hostname string, checks []string) (*HealthChecksResp, error) {
	args := f.Called(hostname, checks)
	return args.Get(0).(*HealthChecksResp), args.Error(1)
}

func (f *Fake) IsProjectOwner(project string, owner string) (bool, error) {
	args := f.Called(project, owner)
	return args.Bool(0), args.Error(1)
}

func (f *Fake) CancelTask(hostname string) error {
	args := f.Called(hostname)
	return args.Error(0)
}

func (f *Fake) UpdateLastTask(host *pb.Host) error {
	args := f.Called(host)
	return args.Error(0)
}

func (f *Fake) HandleFailure(hostname string, req *HandleFailureRequest) error {
	args := f.Called(hostname, req)
	return args.Error(0)
}
