package walle

import (
	"github.com/stretchr/testify/require"
	"testing"
)

func TestInferYPClusterByTag(t *testing.T) {
	require.Equal(t, InferYPClusterByTag([]string{}, ""), "")
	require.Equal(t, InferYPClusterByTag([]string{"rtc.ypmaster-vla", "rtc.ypmaster-man"}, ""), "")
	require.Equal(t, InferYPClusterByTag([]string{"rtc.ypmaster-vla", "sometag"}, "vla"), "vla.yp.yandex.net")
	require.Equal(t, InferYPClusterByTag([]string{"rtc.ypmaster-xdc", "sometag"}, "vla"), "xdc.yp.yandex.net")
	require.Equal(t, InferYPClusterByTag([]string{}, "vla"), "vla.yp.yandex.net")
	require.Equal(t, InferYPClusterByTag([]string{"sometag"}, "vla"), "vla.yp.yandex.net")
	require.Equal(t, InferYPClusterByTag([]string{"rtc.ypmaster-fakedc"}, "vla"), "vla.yp.yandex.net")
	require.Equal(t, InferYPClusterByTag([]string{"sometag"}, "fakedc"), "")
}
