package yamlutils

import (
	"encoding/json"
	"io/ioutil"

	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
	"gopkg.in/yaml.v2"

	y "a.yandex-team.ru/infra/orly/go/orly/yamlutil"
)

var marshaller = protojson.MarshalOptions{
	UseProtoNames:   true,
	EmitUnpopulated: true,
}

func ReadFromFile(path string, m proto.Message) error {
	yamlFile, err := ioutil.ReadFile(path)
	if err != nil {
		return err
	}
	return YAMLToProto(yamlFile, m)
}

func YAMLToProto(yamlBytes []byte, m proto.Message) error {
	var data map[string]interface{}
	err := y.Unmarshal(yamlBytes, &data)
	if err != nil {
		return err
	}
	j, err := json.Marshal(data)
	if err != nil {
		return err
	}
	err = protojson.Unmarshal(j, m)
	if err != nil {
		return err
	}
	return nil
}

// We do not use default yaml marshalling on proto. We'll had problems with durations and timestamps.
func ProtoToYaml(m proto.Message) ([]byte, error) {
	jsonMessage, err := marshaller.Marshal(m)
	if err != nil {
		return nil, err
	}
	var messageInterface interface{}
	err = json.Unmarshal(jsonMessage, &messageInterface)
	if err != nil {
		return nil, err
	}
	yamlMessage, err := yaml.Marshal(messageInterface)
	if err != nil {
		return nil, err
	}
	return yamlMessage, nil
}
