import {SERVER_URL} from '../config'
import yamlJs from 'js-yaml'

export class Api {
    async getJob(name) {
        const res = await fetch(`${SERVER_URL}/api/jobs/${name}`);
        const respJson = await res.json();
        return respJson.job;
    }

    async getSpec(name) {
        const job = await this.getJob(name);
        return job.job.spec;
    }

    async listJobs() {
        const res = await fetch(`${SERVER_URL}/api/jobs`);
        const respJson = await res.json();
        return respJson.jobs;
    }

    async getJobs() {
        const res = await fetch(`${SERVER_URL}/api/jobs-summary`);
        const loadedJobs = (await res.json()).jobs;
        loadedJobs.sort((a, b) => {
            if (a.jobId < b.jobId)
                return -1;
            return 1
        })
        return loadedJobs;
    }

    async putJob(spec) {
        const s = yamlJs.safeLoad(spec);
        const req = {spec: s};
        const resp = await fetch(`${SERVER_URL}/api/jobs`, {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify(req)
        });
        const text = await resp.text();
        return {ok: resp.status === 200, text};
    }

    async deleteJob(jobId) {
        const resp = await fetch(`${SERVER_URL}/api/jobs/${jobId}/delete`, {method: 'DELETE',});
        return resp.status === 200;
    }

    async stopJob(jobId) {
        const resp = await fetch(`${SERVER_URL}/api/jobs/${jobId}`, {method: 'DELETE'});
        return resp.status === 200;
    }

    async stopAllJob() {
        const resp = await fetch(`${SERVER_URL}/api/jobs/stopall`);
        const respJson = await resp.json();
        return respJson.stopped;
    }

    async resumeAllJobs() {
	const resp = await fetch(`${SERVER_URL}/api/jobs/resumeall`);
	const respJson = await resp.json();
	return respJson.resumed;
    }

    async resumeJob(name) {
        const resp = await fetch(`${SERVER_URL}/api/jobs/${name}/resume`, {method: 'POST'})
        return resp.status === 200
    }

    async master() {
        const resp = await fetch(`${SERVER_URL}/api/master`)
        const respJson = await resp.json();
        return respJson.master;
    }

    async mute(job, hostname) {
        const resp = await fetch(`${SERVER_URL}/api/MuteTask`, {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({job, hostname})
        });
        if (resp.status !== 200) {
            return {ok: false, err: await resp.text()};
        }
        return {ok: true, err: ""};
    }
}
