package ui

import (
	"io"
	"net/http"
	"strconv"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/httputil/headers"
	"a.yandex-team.ru/library/go/httputil/resource"
)

var dir = resource.Dir("/")

func NewHandler() *Handler {
	l, _ := zap.New(zap.ConsoleConfig(log.InfoLevel))
	return &Handler{
		l: l,
	}
}

type Handler struct {
	l *zap.Logger
}

func (h *Handler) Register(mux *chi.Mux) {
	mux.Handle("/public/*", http.FileServer(dir))
	mux.Get("/*", SpaHandler)
}

/* Single page application handler for UI, all requests are served with index.html
   and JS machinery handles routes itself.
*/
func SpaHandler(w http.ResponseWriter, _ *http.Request) {
	f, err := dir.Open("public/index.html")
	if err != nil {
		er(err, w, 500)
		return
	}
	_, err = io.Copy(w, f)
	if err != nil {
		er(err, w, 500)
		return
	}
	w.Header().Set(headers.ContentTypeKey, headers.TypeTextHTML.String())
}

func er(err error, w http.ResponseWriter, statusCode int) {
	w.WriteHeader(statusCode)
	resp := []byte(err.Error())
	w.Header().Set(headers.ContentTypeKey, headers.TypeTextPlain.String())
	w.Header().Set(headers.ContentLength, strconv.Itoa(len(resp)))
	_, _ = w.Write(resp)
}
