from __future__ import unicode_literals
import collections


class OpenCircuitBreakerError(Exception):
    pass


class CircuitBreaker(object):
    OPEN_MESSAGE_TPL = "Too much failed operations occured in cluster {}"

    def __init__(self, is_enabled, max_tries):
        self.is_enabled = is_enabled
        self.max_tries = max_tries
        self._failed_tries = collections.defaultdict(int)

    def is_open(self, cluster):
        if not self.is_enabled:
            return False
        return self._failed_tries[cluster] >= self.max_tries

    def raise_if_open(self, cluster):
        if not self.is_open(cluster):
            return
        raise OpenCircuitBreakerError(self.OPEN_MESSAGE_TPL.format(cluster))

    def increment_operation_failed_counter(self, cluster):
        self._failed_tries[cluster] += 1

    def reset(self):
        self._failed_tries = collections.defaultdict(int)
