try:
    import argparse

    from infra.swatlib import cmdutil
    from infra.mc_rsc.src.app import mc_rsc
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    p = argparse.ArgumentParser(description=mc_rsc.Application.name)
    p.add_argument('-v', '--version',
                   action='version',
                   version='0.0.1')
    p.add_argument('-c', '--cfg',
                   default=None,
                   action='store', help='path to service cfg file')
    # --console is used to dump logs during debugging with IDE
    # when stdout isn't terminal but we don't want to log to file
    p.add_argument('--console',
                   default=False,
                   action='store_true',
                   help='redirect log to stdout (overrides config)')
    p.add_argument('-d', '--debug',
                   default=False,
                   action='store_true',
                   help='do NOT daemonize, do NOT change working dir')
    return p


def main():
    cmdutil.main(init_arg_parser(), mc_rsc.Application, env_prefix='MC_RSC')


if __name__ == '__main__':
    main()
