import re

RSC_DEPLOY_ENGINE = "RSC"
MCRSC_DEPLOY_ENGINE = "MCRSC"

DEFAULT_OBJECT_SELECTORS = ["/meta", "/spec", "/status", "/labels"]
DEFAULT_NODE_SEGMENT_ID = "default"
DEFAULT_CIRCUIT_BREAKER_MAX_TRIES = 10
DEFAULT_RATE_LIMITER_DELAY_SECS = 3

POD_INDEX_LABEL = "pod_index"
ENABLE_ENUMERATED_POD_IDS_LABEL = "yd.enable_enumerated_pod_ids"
ENUMERATED_POD_SET_ID_REGEX = re.compile(r'^[a-zA-Z][a-zA-Z0-9-\.]*$')

DISABLE_PODS_MOVE_LABEL = "yd.disable_pods_move"
TEMP_NODE_SEGMENT_LABEL = "yd.node_segment_id"

DELEGATE_REMOVING_LABEL = "yd.delegate_removing_required"

POD_AGENT_SPEC_REVISION_PATH = '/spec/pod_agent_payload/spec/revision'
POD_SELECTORS = [
    "/meta",
    "/spec/resource_requests",
    "/spec/disk_volume_requests",
    "/spec/ip6_address_requests",
    "/spec/host_devices",
    POD_AGENT_SPEC_REVISION_PATH,
    "/spec/pod_agent_payload/spec/target_state",
    "/status",
    "/labels"
]

POD_WATCH_SELECTORS = [
    "/spec",
    "/status/agent/pod_agent_payload/status/revision",
    "/status/agent/pod_agent_payload/status/ready",
    "/status/agent/pod_agent_payload/status/in_progress",
    "/status/agent/pod_agent_payload/status/failed",
    "/status/eviction",
    "/status/scheduling",
    "/status/node_alerts",
    "/status/maintenance/info",
    "/status/maintenance/state"
]

RELATION_SELECTORS = ["/meta"]

DISABLE_SET_TARGET_STATE_REMOVED_LABEL = "yd.disable_set_target_state_removed"
DEPLOY_POLICY_LABEL = "yd.deploy_policy"
DISABLE_PERMANENTLY_LABEL = "disable_permanently"
MAX_DESTROY_HOOK_PERIOD_SECS = 3600


class ReadyThresholdTypes(object):
    MAX_UNAVAILABLE = "MAX_UNAVAILABLE"
    AUTO = "AUTO"
    MIN_READY_PODS_PERCENT = "MIN_READY_PODS_PERCENT"
    MAX_NOT_READY_PODS = "MAX_NOT_READY_PODS"
