from __future__ import unicode_literals

import yp.common
from infra.swatlib.gevent import greenthread


class ClusterTask(greenthread.GreenThread):

    def __init__(self, task, task_args, task_kwargs,
                 cluster, mc_rs_id, circuit_breaker, rate_limiter,
                 check_rate_limiter, logger):
        super(ClusterTask, self).__init__()
        self.task = task
        self.task_args = task_args or ()
        self.task_kwargs = task_kwargs or {}
        self.cluster = cluster
        self.mc_rs_id = mc_rs_id
        self.circuit_breaker = circuit_breaker
        self.rate_limiter = rate_limiter
        self.check_rate_limiter = rate_limiter
        self.logger = logger

    @staticmethod
    def _log_exception(func):
        return func

    def run(self):
        if self.check_rate_limiter:
            is_allowed, msg = self.rate_limiter.is_process_allowed(
                self.mc_rs_id
            )
            if not is_allowed:
                self.logger.info(msg)
                return

        self.circuit_breaker.raise_if_open(self.cluster)
        try:
            self.task(*self.task_args, **self.task_kwargs)
        except yp.common.GrpcError:
            self.circuit_breaker.increment_operation_failed_counter(
                self.cluster
            )
            raise
        finally:
            if self.check_rate_limiter:
                self.rate_limiter.update_last_process_time(self.mc_rs_id)


def apply_cluster_tasks(tasks):
    for task in tasks:
        task.start()
    errors = {}
    for task in tasks:
        try:
            task.get()
        except Exception as e:
            errors[task.cluster] = e
    return errors
