from __future__ import unicode_literals

from infra.mc_rsc.src import yputil


def validate_spec_clusters(mc_rs, clusters):
    unknown_clusters = set()
    for c in mc_rs.list_spec_clusters():
        if c not in clusters:
            unknown_clusters.add(c)
    if unknown_clusters:
        unknown_s = ','.join(unknown_clusters)
        allowed_s = ','.join(clusters)
        msg = "unknown clusters: {}; allowed are: {}".format(unknown_s,
                                                             allowed_s)
        raise ValueError(msg)


def validate_pod_set_labels_matched(ps, match_labels, raise_if_not_matched):
    diff = yputil.make_labels_diff(ps.labels, match_labels)
    if raise_if_not_matched and diff:
        raise ValueError("podset {} already exists".format(ps.meta.id))
    return not diff
