from __future__ import unicode_literals


class Condition(object):

    def __init__(self, succeeded, reason, message, last_transition_time):
        self.succeeded = succeeded
        self.reason = reason
        self.message = message
        self.last_transition_time = last_transition_time

    def set_success(self, last_transition_time):
        self.succeeded = True
        self.reason = ''
        self.message = ''
        self.last_transition_time = last_transition_time

    def set_error(self, reason, message, last_transition_time):
        self.succeeded = False
        self.reason = reason
        self.message = message
        self.last_transition_time = last_transition_time

    def __str__(self):
        if self.succeeded:
            return 'OK'
        if self.message:
            return 'Failed: {}'.format(self.message)
        elif self.reason:
            return 'Failed: {}'.format(self.reason)
        return 'Failed'
