from __future__ import unicode_literals
import logging

from infra.swatlib.gevent import greenthread


class Manager(greenthread.GreenThread):
    """Manages reflectors, runner and gc."""

    def __init__(self, ps_gcs, ctl_runner):
        super(Manager, self).__init__()
        self.ps_gcs = ps_gcs
        self.ctl_runner = ctl_runner
        self.log = logging.getLogger('manager')

    def run(self):
        try:
            self.log.info("starting pod_set gcs...")
            for pg in self.ps_gcs:
                pg.start()
            self.log.info("pod_set gcs started")

            self.log.info("starting ctl runner...")
            self.ctl_runner.start()
            self.log.info("ctl runner started: waiting infinitely...")
            # Block here.
            self.ctl_runner.wait()
        finally:
            # DEPLOY-1583: restart process in case of:
            # * lock release
            # * standoff timeout
            # * ZK session failure
            # * all the other cases when manager is stopping
            raise SystemExit(123)

            self.log.info("stopping pod_set gcs...")
            for pg in self.ps_gcs:
                pg.stop()
            self.log.info("pod_set gcs stopped")

            self.log.info("stopping ctl runner...")
            self.ctl_runner.stop()
            self.log.info("ctl runner stopped")
