from __future__ import unicode_literals


class MetricsCollector(object):
    def __init__(self, metrics_registry, cluster):
        self._metrics_registry = metrics_registry
        self._cluster = cluster

    def get_metric_name(self, n):
        return '{}-{}'.format(n, self._cluster)

    def collect(self, ctl_results):
        eviction_ack_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('eviction_acknowledged_pods')
        )
        maintenance_ack_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('maintenance_acknowledged_pods')
        )
        created_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('created_pods')
        )
        removed_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('removed_pods')
        )
        replaced_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('replaced_pods')
        )
        updated_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('updated_pods')
        )
        reallocated_inplace_pods_counter = self._metrics_registry.get_counter(
            self.get_metric_name('reallocated_inplace_pods')
        )
        mc_rs_eviction_happened_counter = self._metrics_registry.get_counter(
            self.get_metric_name('mc_rs_eviction_happened')
        )
        eviction_requested_pods = 0
        mc_rs_missed_eviction = 0

        for r in ctl_results:
            eviction_ack_pods_counter.inc(r.eviction_acknowledged_pods)
            maintenance_ack_pods_counter.inc(r.maintenance_acknowledged_pods)
            created_pods_counter.inc(r.created_pods)
            removed_pods_counter.inc(r.removed_pods)
            replaced_pods_counter.inc(r.replaced_pods)
            updated_pods_counter.inc(r.updated_pods)
            reallocated_inplace_pods_counter.inc(r.reallocated_inplace_pods)
            eviction_requested_pods += r.eviction_requested_pods
            missed_eviction = (r.is_mc_rs_ready and
                               r.eviction_requested_pods and
                               not r.eviction_acknowledged_pods)
            if missed_eviction:
                mc_rs_missed_eviction += 1
            if r.eviction_acknowledged_pods:
                mc_rs_eviction_happened_counter.inc(1)

        self._metrics_registry.get_gauge(
            self.get_metric_name('eviction_requested_pods')
        ).set(eviction_requested_pods)
        self._metrics_registry.get_gauge(
            self.get_metric_name('mc_rs_missed_eviction')
        ).set(mc_rs_missed_eviction)
