from __future__ import unicode_literals
import collections


class PodActionKind(object):
    CreatePods = "create"
    RemovePods = "remove"
    UpdatePods = "update"
    UpdatePodsPreserveAllocation = "update_preserve_allocation"
    ReallocatePods = "reallocate"
    ReplacePods = "replace"
    RequestEvictionPods = "request_eviction"
    MarkDelegateRemovingPods = "mark_delegate_removing"
    DelegateRemovingPods = "delegate_removing"
    AcknowledgeEvictionPods = "acknowledge_eviction"
    AcknowledgeMaintenancePods = "acknowledge_maintenance"
    SetTargetStateRemovedPods = 'set_target_state_removed'
    SetTargetStateActivePods = 'set_target_state_active'
    ReplacePodsWithNewIds = 'replace_pods_with_new_ids'


class CreateAction(object):
    kind = PodActionKind.CreatePods

    def __init__(self):
        self._d = {}

    def add(self, count, cluster):
        self._d[cluster] = count

    def list_count_by_cluster(self):
        return self._d.iteritems()

    def count_all(self):
        return sum(self._d.itervalues())

    def is_empty(self):
        return not self._d


class UpdateAction(object):
    kind = PodActionKind.UpdatePods

    def __init__(self):
        self._d = collections.defaultdict(set)

    def add(self, pod_id, cluster):
        self._d[cluster].add(pod_id)

    def list_grouped_by_cluster_pod_ids(self):
        return self._d.iteritems()

    def count_all(self):
        return sum(len(ids) for ids in self._d.itervalues())

    def is_empty(self):
        return not self._d


class UpdatePreserveAllocationAction(UpdateAction):
    kind = PodActionKind.UpdatePodsPreserveAllocation


class ReallocateAction(UpdateAction):
    kind = PodActionKind.ReallocatePods


class ReplaceAction(UpdateAction):
    kind = PodActionKind.ReplacePods


class RemoveAction(UpdateAction):
    kind = PodActionKind.RemovePods


class RequestEvictionAction(UpdateAction):
    kind = PodActionKind.RequestEvictionPods


class MarkDelegateRemovingAction(UpdateAction):
    kind = PodActionKind.MarkDelegateRemovingPods


class DelegateRemovingAction(UpdateAction):
    kind = PodActionKind.DelegateRemovingPods


class AcknowledgeEvictionAction(UpdateAction):
    kind = PodActionKind.AcknowledgeEvictionPods


class AcknowledgeMaintenanceAction(UpdateAction):
    kind = PodActionKind.AcknowledgeMaintenancePods


class SetTargetStateRemovedAction(UpdateAction):
    kind = PodActionKind.SetTargetStateRemovedPods


class SetTargetStateActiveAction(UpdateAction):
    kind = PodActionKind.SetTargetStateActivePods


class ReplacePodsWithNewIdsAction(UpdateAction):
    kind = PodActionKind.ReplacePodsWithNewIds
