from __future__ import unicode_literals
import collections
import time
from datetime import datetime


class RateLimiter(object):
    def __init__(self, is_enabled, delay_secs):
        self.delay_secs = delay_secs
        self.last_process_time = collections.defaultdict(int)
        self.is_enabled = is_enabled

    def update_last_process_time(self, mc_rs_id):
        self.last_process_time[mc_rs_id] = int(time.time())

    def is_process_allowed(self, mc_rs_id):
        if not self.is_enabled:
            return True, ''

        must_wait_for = self.last_process_time[mc_rs_id] + self.delay_secs
        if must_wait_for < int(time.time()):
            return True, ''

        m = 'Last eviction time {}, will wait until {}'.format(
            self.last_process_time[mc_rs_id],
            datetime.fromtimestamp(must_wait_for)
        )
        return False, m
