from __future__ import unicode_literals
import time

from infra.mc_rsc.src.lib import condition


def make_not_synced_condition():
    return condition.Condition(succeeded=False,
                               reason='not synced',
                               message='not synced',
                               last_transition_time=int(time.time()))


class SyncCondition(object):
    def __init__(self, cluster):
        self.cluster = cluster
        self.condition = make_not_synced_condition()

    def set_success(self):
        self.condition.set_success(last_transition_time=int(time.time()))

    def set_error(self, reason, message):
        self.condition.set_error(reason, message, last_transition_time=int(time.time()))

    def get_error_by_sync_ts(self, sync_ts):
        if self.condition.last_transition_time < sync_ts:
            return make_not_synced_condition()
        if not self.condition.succeeded:
            return self.condition

    def __str__(self):
        return str(self.condition)
