from __future__ import unicode_literals


class IYpClientAdapter(object):

    def get_ignore(self, mc_rs_id, selectors):
        raise NotImplementedError

    def update_status(self, mc_rs_id, status):
        raise NotImplementedError

    def add_deploy_child(self, mc_rs_id, child):
        raise NotImplementedError

    def remove_deploy_child(self, mc_rs_id, child):
        raise NotImplementedError


class RsYpClientAdapter(IYpClientAdapter):

    def __init__(self, yp_client):
        self.yp_client = yp_client

    def get_ignore(self, mc_rs_id, selectors):
        self.yp_client.get_replica_set_ignore(rs_id=mc_rs_id, selectors=selectors)

    def update_status(self, mc_rs_id, status):
        self.yp_client.update_replica_set_status(rs_id=mc_rs_id, status=status)

    def add_deploy_child(self, mc_rs_id, child):
        self.yp_client.add_deploy_child_to_rs(rs_id=mc_rs_id, child=child)

    def remove_deploy_child(self, mc_rs_id, child):
        self.yp_client.remove_deploy_child_from_rs(rs_id=mc_rs_id, child=child)


class McrsYpClientAdapter(IYpClientAdapter):

    def __init__(self, yp_client):
        self.yp_client = yp_client

    def get_ignore(self, mc_rs_id, selectors):
        self.yp_client.get_multi_cluster_replica_set_ignore(mcrs_id=mc_rs_id, selectors=selectors)

    def update_status(self, mc_rs_id, status):
        self.yp_client.update_multi_cluster_replica_set_status(mcrs_id=mc_rs_id, status=status)

    def add_deploy_child(self, mc_rs_id, child):
        self.yp_client.add_deploy_child_to_mcrs(mcrs_id=mc_rs_id, child=child)

    def remove_deploy_child(self, mc_rs_id, child):
        self.yp_client.remove_deploy_child_from_mcrs(mcrs_id=mc_rs_id, child=child)
