from __future__ import unicode_literals

import yt.common
import yt.yson as yson
import yp.data_model


YT_ERROR_NONDETERMINISTIC_ATTR_NAMES = {
    'datetime',
    'host',
    'origin',
    'request_id',
    'span_id',
    'trace_id',
}


def get_label(labels, key, default=None):
    for a in labels.attributes:
        if a.key == key:
            return yson.loads(a.value)
    return default


def set_label(labels, key, value):
    attr = None
    for a in labels.attributes:
        if a.key == key:
            attr = a
            break
    if attr is None:
        attr = labels.attributes.add()
        attr.key = key
    attr.value = yson.dumps(value)


def make_dict_from_labels(labels):
    d = {}
    for a in labels.attributes:
        v = yson.loads(a.value)
        if v is not None:
            d[a.key] = yson.loads(a.value)
    return d


def make_labels_from_dict(d):
    rv = yp.data_model.TAttributeDictionary()
    for k, v in d.iteritems():
        if v is not None:
            set_label(rv, k, v)
    return rv


def make_labels_diff(labels, match_labels):
    d = make_dict_from_labels(labels)
    diff = {}
    for a in match_labels.attributes:
        match_v = yson.loads(a.value)
        v = d.get(a.key)
        if v != match_v:
            diff[a.key] = (v, match_v)
    return diff


def make_filter_from_dict(d):
    parts = []
    for k, v in d.iteritems():
        if v is None:
            p = '[/labels/{}] = null'.format(k)
        else:
            p = '[/labels/{}] = "{}"'.format(k, v)
        parts.append(p)
    return ' AND '.join(parts)


def cast_yp_timestamp_to_seconds(ts):
    return ts >> 30


def clear_nondeterministic_attrs_from_yt_error(e):
    # YT errors have some attributes that change on every request even if
    # error is the same. For example: origin, request_id, etc. We save error to
    # replicaset status and do not want to update failed status if error has
    # not changed.
    if isinstance(e, yt.common.YtError):
        attrs = e.attributes
        inner_errors = e.inner_errors
    elif isinstance(e, dict):
        attrs = e.get('attributes') or {}
        inner_errors = e.get('inner_errors') or []
    else:
        return e
    for name in YT_ERROR_NONDETERMINISTIC_ATTR_NAMES:
        attrs.pop(name, None)
    for inner_e in inner_errors:
        clear_nondeterministic_attrs_from_yt_error(inner_e)
    return e
