#include "application.h"
#include <library/cpp/testing/unittest/registar.h>

using namespace NMonitoring;

Y_UNIT_TEST_SUITE(ApplicationOptions) {
    Y_UNIT_TEST(TestHttpPort) {
        int argc = 2;
        char* argv[] = {
            (char*)"cmd",
            (char*)"--http-port=10000"
        };

        auto options = NLastGetopt::TOpts::Default();
        FillParser(options);

        NLastGetopt::TOptsParseResult parsed(&options, argc, argv);
        TSettings settings;

        ProcessParsedOptions(parsed, settings);

        UNIT_ASSERT_VALUES_EQUAL(settings.GetHttpPort(), 10000);
    }

    Y_UNIT_TEST(TestHttpThreadsIsOptional) {
        int argcDefault = 1;
        char* argvDefault[] = {
            (char*)"cmd"
        };

        auto optionsDefault = NLastGetopt::TOpts::Default();
        FillParser(optionsDefault);
        TSettings settingsWithDefaultThreadCount;

        NLastGetopt::TOptsParseResult parsedDefault(&optionsDefault, argcDefault, argvDefault);
        ProcessParsedOptions(parsedDefault, settingsWithDefaultThreadCount);

        int argc = 2;
        char* argv[] = {
            (char*)"cmd",
            (char*)"--http-threads=19"
        };

        auto options = NLastGetopt::TOpts::Default();
        FillParser(options);

        NLastGetopt::TOptsParseResult parsed(&options, argc, argv);
        TSettings settings;

        ProcessParsedOptions(parsed, settings);

        UNIT_ASSERT_VALUES_EQUAL(settings.GetHttpThreadPoolSize(), 19);
        UNIT_ASSERT_VALUES_UNEQUAL(settings.GetHttpThreadPoolSize(), settingsWithDefaultThreadCount.GetHttpThreadPoolSize());
    }
}

