#pragma once

#include <util/generic/iterator.h>
#include <util/generic/iterator_range.h>
#include <util/generic/vector.h>

namespace NMonitoring {
    template <class T>
    inline TVector<TIteratorRange<typename TVector<T>::const_iterator>> SplitChunks(const TVector<T>& data, size_t size) {
        auto begin = data.cbegin();
        auto end = begin + size;
        TVector<TIteratorRange<typename TVector<T>::const_iterator>> result;

        while (end < data.cend()) {
            result.push_back(MakeIteratorRange(begin, end));
            begin = end;
            end += size;
        }
        if (begin != data.cend()) {
            result.push_back(MakeIteratorRange(begin, data.cend()));
        }
        return result;
    }

    template <class T>
    inline TVector<typename T::mapped_type> MapValues(const T& map) {
        TVector<typename T::mapped_type> result(Reserve(map.size()));
        for (const auto& pair : map) {
            result.push_back(pair.second);
        }
        return result;
    }

    template <class T>
    inline TVector<typename T::key_type> MapKeys(const T& map) {
        TVector<typename T::key_type> result(Reserve(map.size()));
        for (const auto& pair : map) {
            result.push_back(pair.first);
        }
        return result;
    }
} // namespace NMonitoring
