#include "http_metrics.h"

#include <util/string/cast.h>

namespace NMonitoring {
    NMonitoring::ILabelsPtr THttpCallMetrics::MakeLabels(TStringBuf name, const NMonitoring::TLabels& additional) {
        NMonitoring::ILabelsPtr result{new NMonitoring::TLabels};
        TString fullName = Prefix_ + name;
        result->Add("sensor", fullName);
        for (const auto& l: CommonLabels_) {
            result->Add(l);
        }
        for (const auto& l: additional) {
            result->Add(l);
        }
        return result;
    }

    NMonitoring::IRate* THttpCallMetrics::ResolveStatus(HttpCodes code) {
        {
            TLightReadGuard g{Lock_};
            auto it = Status_.find(code);
            if (it != Status_.end()) {
                return it->second;
            }
        }

        TString codeStr = IntToString<10>(static_cast<int>(code));
        auto* metric = Registry_.Rate(MakeLabels(".call.status", {{"code", codeStr}}));
        {
            TLightWriteGuard g{Lock_};
            Status_[code] = metric;
        }
        return metric;
    }
} // namespace NMonitoring
