#pragma once

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

namespace NMonitoring {
    class THttpCallMetrics {
    public:
        THttpCallMetrics(NMonitoring::IMetricRegistry& registry, NMonitoring::TLabels labels, TString prefix)
            : Registry_{registry}
            , CommonLabels_{std::move(labels)}
            , Prefix_{std::move(prefix)}
        {
            Timings_ = registry.HistogramRate(
                MakeLabels(".call.elapsedTimeMs"),
                NMonitoring::ExponentialHistogram(13, 2, 16));
            Started_ = registry.Rate(MakeLabels(".call.started"));
            Completed_ = registry.Rate(MakeLabels(".call.completed"));
            Inflight_ = registry.IntGauge(MakeLabels(".call.inFlight"));
        }

        void CallStarted() {
            Started_->Inc();
            Inflight_->Inc();
        }

        void CallCompleted(HttpCodes code, TDuration elapsedTime) {
            Completed_->Inc();
            Inflight_->Dec();
            Timings_->Record(elapsedTime.MilliSeconds());
            ResolveStatus(code)->Inc();
        }


    private:
        NMonitoring::IMetricRegistry& Registry_;
        const NMonitoring::TLabels CommonLabels_;
        const TString Prefix_;
        NMonitoring::IHistogram* Timings_{};
        NMonitoring::IRate* Started_{};
        NMonitoring::IRate* Completed_{};
        NMonitoring::IIntGauge* Inflight_{};
        TLightRWLock Lock_;
        THashMap<HttpCodes, NMonitoring::IRate*> Status_;

        NMonitoring::ILabelsPtr MakeLabels(TStringBuf name, const NMonitoring::TLabels& additional = {});
        NMonitoring::IRate* ResolveStatus(HttpCodes code);
    };
} // namespace NMonitoring
